#
# Makefile for building demo CRS application program
#
# Build CRS application: 
# 
#       make -f demo_crs.mk clean crsapp
#
# NOTE: 1. ORACLE_HOME must be either:
#                  . set in the user's environment
#                  . passed in on the command line
#                  . defined in a modified version of this makefile
#
#       2. Look in the platform specific documentation for information
#          about environment variables that need to be properly
#          defined (e.g. LD_LIBRARY_PATH in Solaris).
#

include $(ORACLE_HOME)/crs/lib/env_has.mk

BUILD = build
DEMO_DIR = $(ORACLE_HOME)/crs/demo
DEMO_MAKEFILE = $(DEMO_DIR)/demo_crs.mk

DEMOS = crsapp

demos: $(DEMOS)

$(DEMOS):$(OBJS)
	$(MAKE) -f $(DEMO_MAKEFILE) $(BUILD) EXE=$@$(EXE_SUFFIX) OBJS=$@.$(OBJ_EXT)

build: $(OBJS)
	$(BUILDEXE)

.c.$(OBJ_EXT):
	$(C2O) 

crsapp.$(OBJ_EXT):crsapp.c
	$(C2O) 

clean:
	$(RM) -f $(DEMOS) *.$(OBJ_EXT)

